<?php
// Sāk sesiju
session_start();
// Iekļauj konfigurācijas failu
require_once 'config.php';

// Pārbauda, vai ir izvēlēts tests
if (!isset($_POST['test_id'])) {
    echo "Nav izvēlēts tests";
    exit;
}

$testId = $_POST['test_id'];

// Veido savienojumu ar datu bāzi
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojuma statusu
if ($conn->connect_error) {
    die("Savienojums neizdevās: " . $conn->connect_error);
}

// Sagatavo SQL vaicājumu, lai izvēlētos jautājumus no konkrēta testa
$sql = "SELECT id, question_text FROM questions WHERE test_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $testId);
$stmt->execute();
$result = $stmt->get_result();

$questions = [];

// Ja rezultātos ir vairāk nekā 0 rindas, izgūst jautājumu datus
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $questions[] = $row;
    }
} else {
    // Ja nav jautājumu šim testam, izvada atbilstošu paziņojumu un pārtrauc skriptu
    echo "Nav jautājumu šim testam";
    exit;
}

// Aizver datu bāzes savienojumu
$conn->close();

// Saglabā testa ID un jautājumu datus sesijā
$_SESSION['test_id'] = $testId;
$_SESSION['questions'] = $questions;

// Novirza uz pilnīga testa lapu ar soli 1
header('Location: complete_test.php?step=1');
exit;
?>
